unit BrowserMain;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel, System.Globalization,
  System.Windows.Forms, System.Data, System.Threading;

type
  TMainForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ListViewCulture: System.Windows.Forms.ListView;
    PropertyGridDetail: System.Windows.Forms.PropertyGrid;
    ColumnHeader1: System.Windows.Forms.ColumnHeader;
    ColumnHeader2: System.Windows.Forms.ColumnHeader;
    ColumnHeader3: System.Windows.Forms.ColumnHeader;
    ComboBoxCultureType: System.Windows.Forms.ComboBox;
    GroupBoxList: System.Windows.Forms.GroupBox;
    GroupBoxDetails: System.Windows.Forms.GroupBox;
    ColumnHeader4: System.Windows.Forms.ColumnHeader;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TMainForm_Load(sender: System.Object; e: System.EventArgs);
    procedure ListViewCulture_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure ComboBoxCultureType_SelectedIndexChanged(sender: System.Object;
        e: System.EventArgs);
    procedure ListViewCulture_ColumnClick(sender: System.Object; e: System.Windows.Forms.ColumnClickEventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
    procedure PopulateComboBox;
    procedure PopulateListView;
  private
    type
      TCultureListViewItem = class(ListViewItem)
      private
        FCulture: CultureInfo;
      public
        constructor Create(ACulture: CultureInfo);
        property Culture: CultureInfo read FCulture write FCulture;
      end;

      TListViewItemSorter = class(TInterfacedObject, IComparer)
      private
        FColumn: Integer;
        FDesceding: Boolean;
        procedure SetColumn(Value: Integer);
      public
        function Compare(x: &Object; y: &Object): Integer;
        property Column: Integer read FColumn write SetColumn;
      end;
  private
    FSorter: TMainForm.TListViewItemSorter;
  end;

implementation

{ TMainForm.TCultureListViewItem }

constructor TMainForm.TCultureListViewItem.Create(ACulture: CultureInfo);
begin
  inherited Create;
  FCulture := ACulture;
  Text := Culture.Name;
  SubItems.Add(Culture.DisplayName);
  SubItems.Add(Culture.EnglishName);
  SubItems.Add(Culture.NativeName);
end;

{ TMainForm.TListViewItemSorter }

function TMainForm.TListViewItemSorter.Compare(x: &Object; y: &Object): Integer;
begin
  Result := System.String.Compare(ListViewItem(x).SubItems[FColumn].Text, ListViewItem(y).SubItems[FColumn].Text);
  if FDesceding then
    Result := -Result;
end;

procedure TMainForm.TListViewItemSorter.SetColumn(Value: Integer);
begin
  if FColumn = Value then
    FDesceding := not FDesceding
  else
  begin
    FDesceding := False;
    FColumn := Value;
  end;
end;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TMainForm.InitializeComponent;
begin
  Self.PropertyGridDetail := System.Windows.Forms.PropertyGrid.Create;
  Self.GroupBoxList := System.Windows.Forms.GroupBox.Create;
  Self.ComboBoxCultureType := System.Windows.Forms.ComboBox.Create;
  Self.ListViewCulture := System.Windows.Forms.ListView.Create;
  Self.ColumnHeader1 := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnHeader2 := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnHeader3 := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnHeader4 := System.Windows.Forms.ColumnHeader.Create;
  Self.GroupBoxDetails := System.Windows.Forms.GroupBox.Create;
  Self.GroupBoxList.SuspendLayout;
  Self.GroupBoxDetails.SuspendLayout;
  Self.SuspendLayout;
  // 
  // PropertyGridDetail
  // 
  Self.PropertyGridDetail.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.PropertyGridDetail.CommandsVisibleIfAvailable := True;
  Self.PropertyGridDetail.HelpVisible := False;
  Self.PropertyGridDetail.LargeButtons := False;
  Self.PropertyGridDetail.LineColor := System.Drawing.SystemColors.ScrollBar;
  Self.PropertyGridDetail.Location := System.Drawing.Point.Create(8, 16);
  Self.PropertyGridDetail.Name := 'PropertyGridDetail';
  Self.PropertyGridDetail.PropertySort := System.Windows.Forms.PropertySort.Alphabetical;
  Self.PropertyGridDetail.Size := System.Drawing.Size.Create(696, 256);
  Self.PropertyGridDetail.TabIndex := 1;
  Self.PropertyGridDetail.Text := 'Detail';
  Self.PropertyGridDetail.ToolbarVisible := False;
  Self.PropertyGridDetail.ViewBackColor := System.Drawing.SystemColors.Window;
  Self.PropertyGridDetail.ViewForeColor := System.Drawing.SystemColors.WindowText;
  // 
  // GroupBoxList
  // 
  Self.GroupBoxList.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.GroupBoxList.Controls.Add(Self.ComboBoxCultureType);
  Self.GroupBoxList.Controls.Add(Self.ListViewCulture);
  Self.GroupBoxList.Location := System.Drawing.Point.Create(8, 8);
  Self.GroupBoxList.Name := 'GroupBoxList';
  Self.GroupBoxList.Size := System.Drawing.Size.Create(712, 376);
  Self.GroupBoxList.TabIndex := 4;
  Self.GroupBoxList.TabStop := False;
  Self.GroupBoxList.Text := '&List';
  // 
  // ComboBoxCultureType
  // 
  Self.ComboBoxCultureType.DropDownStyle := System.Windows.Forms.ComboBoxStyle.DropDownList;
  Self.ComboBoxCultureType.Location := System.Drawing.Point.Create(8, 16);
  Self.ComboBoxCultureType.Name := 'ComboBoxCultureType';
  Self.ComboBoxCultureType.Size := System.Drawing.Size.Create(232, 21);
  Self.ComboBoxCultureType.TabIndex := 5;
  Include(Self.ComboBoxCultureType.SelectedIndexChanged, Self.ComboBoxCultureType_SelectedIndexChanged);
  // 
  // ListViewCulture
  // 
  Self.ListViewCulture.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.ListViewCulture.Columns.AddRange([Self.ColumnHeader1, Self.ColumnHeader2, Self.ColumnHeader3, Self.ColumnHeader4]);
  Self.ListViewCulture.FullRowSelect := True;
  Self.ListViewCulture.GridLines := True;
  Self.ListViewCulture.Location := System.Drawing.Point.Create(8, 48);
  Self.ListViewCulture.Name := 'ListViewCulture';
  Self.ListViewCulture.Size := System.Drawing.Size.Create(696, 320);
  Self.ListViewCulture.TabIndex := 4;
  Self.ListViewCulture.View := System.Windows.Forms.View.Details;
  Include(Self.ListViewCulture.ColumnClick, Self.ListViewCulture_ColumnClick);
  Include(Self.ListViewCulture.SelectedIndexChanged, Self.ListViewCulture_SelectedIndexChanged);
  // 
  // ColumnHeader1
  // 
  Self.ColumnHeader1.Text := 'Culture';
  // 
  // ColumnHeader2
  // 
  Self.ColumnHeader2.Text := 'Display name';
  Self.ColumnHeader2.Width := 200;
  // 
  // ColumnHeader3
  // 
  Self.ColumnHeader3.Text := 'English name';
  Self.ColumnHeader3.Width := 200;
  // 
  // ColumnHeader4
  // 
  Self.ColumnHeader4.Text := 'Native name';
  Self.ColumnHeader4.Width := 200;
  // 
  // GroupBoxDetails
  // 
  Self.GroupBoxDetails.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Bottom 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.GroupBoxDetails.Controls.Add(Self.PropertyGridDetail);
  Self.GroupBoxDetails.Location := System.Drawing.Point.Create(8, 392);
  Self.GroupBoxDetails.Name := 'GroupBoxDetails';
  Self.GroupBoxDetails.Size := System.Drawing.Size.Create(712, 280);
  Self.GroupBoxDetails.TabIndex := 5;
  Self.GroupBoxDetails.TabStop := False;
  Self.GroupBoxDetails.Text := '&Details';
  // 
  // TMainForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(728, 685);
  Self.Controls.Add(Self.GroupBoxDetails);
  Self.Controls.Add(Self.GroupBoxList);
  Self.Name := 'TMainForm';
  Self.Text := 'CultureInfo browser';
  Include(Self.Load, Self.TMainForm_Load);
  Self.GroupBoxList.ResumeLayout(False);
  Self.GroupBoxDetails.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TMainForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TMainForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  FSorter := TMainForm.TListViewItemSorter.Create;
  ListViewCulture.ListViewItemSorter := FSorter;
end;

procedure TMainForm.PopulateComboBox;
var
  C: CultureTypes;
begin
  ComboBoxCultureType.Items.Clear;
  for C := Low(CultureTypes) to High(CultureTypes) do
    ComboBoxCultureType.Items.Add(&Object(C));
  ComboBoxCultureType.SelectedIndex := 0;
end;

procedure TMainForm.PopulateListView;
var
  I: Integer;
  List: array of CultureInfo;
begin
  ListViewCulture.BeginUpdate;
  try
    ListViewCulture.Items.Clear;
    List := CultureInfo.GetCultures(CultureTypes(ComboBoxCultureType.SelectedItem));
    for I := 0 to Length(List) - 1 do
      if List[I].Name <> '' then
        ListViewCulture.Items.Add(TCultureListViewItem.Create(List[I]));
    ListViewCulture.Sort;
    if ListViewCulture.Items.Count > 0 then
    begin
      ListViewCulture.Items[0].Focused := True;
      ListViewCulture.Items[0].Selected := True;
      ListViewCulture_SelectedIndexChanged(nil, nil);
    end;
  finally
    ListViewCulture.EndUpdate;
  end;
end;

procedure TMainForm.ListViewCulture_ColumnClick(sender: System.Object; e: System.Windows.Forms.ColumnClickEventArgs);
begin
  FSorter.Column := e.Column;
  ListViewCulture.Sort;
end;

procedure TMainForm.ComboBoxCultureType_SelectedIndexChanged(sender: System.Object;
    e: System.EventArgs);
begin
  PopulateListView;
end;

procedure TMainForm.ListViewCulture_SelectedIndexChanged(sender: System.Object;
    e: System.EventArgs);
begin
  PropertyGridDetail.SelectedObject := (ListViewCulture.FocusedItem as TCultureListViewItem).Culture;
end;

procedure TMainForm.TMainForm_Load(sender: System.Object; e: System.EventArgs);
begin
  PopulateComboBox;
end;

end.
